package com.app.yourradioapp593.activities;

import static com.app.yourradioapp593.utils.Constant.PERMISSIONS_REQUEST;

import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.Html;
import android.widget.Button;
import android.widget.ScrollView;
import android.widget.TextView;

import androidx.activity.OnBackPressedCallback;
import androidx.activity.OnBackPressedDispatcher;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;

import com.app.yourradioapp593.BuildConfig;
import com.app.yourradioapp593.Config;
import com.app.yourradioapp593.R;
import com.app.yourradioapp593.database.prefs.SharedPref;
import com.app.yourradioapp593.utils.Tools;

public class ActivityPermission extends AppCompatActivity {

    Button btnAllowPermission;
    Button btnLater;
    TextView txtPermissionTitle;
    TextView txtPermissionMessage;
    TextView txtAppVersion;
    TextView txtPrivacyPolicy;
    SharedPref sharedPref;
    ScrollView scrollView;
    OnBackPressedDispatcher onBackPressedDispatcher;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Tools.getTheme(this);
        setContentView(R.layout.activity_permission);

        sharedPref = new SharedPref(this);
        Tools.setNavigation(this);

        btnAllowPermission = findViewById(R.id.btn_allow_permission);
        btnLater = findViewById(R.id.btn_later);
        txtPermissionTitle = findViewById(R.id.txt_permission_title);
        txtPermissionTitle.setText(getString(R.string.permission_title) + " " + getString(R.string.app_name));

        txtPermissionMessage = findViewById(R.id.txt_permission_message);
        txtAppVersion = findViewById(R.id.txt_app_version);
        txtPrivacyPolicy = findViewById(R.id.txt_privacy_policy);
        scrollView = findViewById(R.id.scroll_view);

        btnAllowPermission.setOnClickListener(v -> Tools.requestPermission(ActivityPermission.this));
        btnLater.setOnClickListener(v -> finish());
        txtAppVersion.setText(getString(R.string.sub_about_app_version) + " " + BuildConfig.VERSION_NAME);
        txtPermissionMessage.setText(Html.fromHtml(getString(R.string.permission_message)));
        txtPrivacyPolicy.setOnClickListener(v -> {
            Intent intent = new Intent(getApplicationContext(), ActivityWebView.class);
            intent.putExtra("title", getResources().getString(R.string.title_setting_privacy));
            intent.putExtra("url", sharedPref.getPrivacyPolicy());
            startActivity(intent);
        });

        if (sharedPref.getIsDarkTheme()) {
            scrollView.setBackgroundResource(R.drawable.bg_rounded_corner_dark);
        } else {
            scrollView.setBackgroundResource(R.drawable.bg_rounded_corner);
        }

        handleOnBackPressed();
        setStatusBar();
//        setBackgroundColor();

    }

    public void handleOnBackPressed() {
        onBackPressedDispatcher = getOnBackPressedDispatcher();
        onBackPressedDispatcher.addCallback(this, new OnBackPressedCallback(true) {
            @Override
            public void handleOnBackPressed() {
                finish();
            }
        });
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == PERMISSIONS_REQUEST) {
            if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                startActivity(new Intent(getApplicationContext(), MainActivity.class));
                finishAffinity();
            }
        }
    }

    private void setStatusBar() {
        if (sharedPref.getIsDarkTheme()) {
            Tools.setStatusBarColor(this, findViewById(R.id.root_view), ContextCompat.getColor(this, R.color.color_dark_status_bar));
        } else {
            if (Config.ENABLE_NEW_UI) {
                Tools.setStatusBarColor(this, findViewById(R.id.root_view), ContextCompat.getColor(this, R.color.color_white));
            } else {
                Tools.setStatusBarColor(this, findViewById(R.id.root_view), ContextCompat.getColor(this, R.color.color_light_status_bar));
            }
        }
    }

//    private void setBackgroundColor() {
//        if (sharedPref.getIsDarkTheme()) {
//            findViewById(R.id.background_view).setBackgroundColor(ContextCompat.getColor(this, R.color.color_dark_background));
//        } else {
//            findViewById(R.id.background_view).setBackgroundColor(ContextCompat.getColor(this, R.color.color_light_background));
//        }
//    }

}
